/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.CompoundStatusManager;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusType;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class LsPortCompStatusMgr
extends CompoundStatusManager {
    private static ResourceBundle lspeedBundle;
    private static String bundleName;

    public LsPortCompStatusMgr() {
        lspeedBundle = ResourceBundle.getBundle(bundleName);
    }

    public String getLabel(Locale locale) {
        return lspeedBundle.getString("PortCompoundPolicyLabel");
    }

    public StatusType compute(CompoundStatus compoundStatus) {
        StatusType statusType = null;
        StatusType statusType2 = null;
        StatusType statusType3 = null;
        boolean bl = false;
        StatusType statusType4 = compoundStatus.getStatusType();
        Vector vector = compoundStatus.getDependents();
        if (vector.size() == 0) {
            statusType4 = StatusType.UNKNOWN;
            compoundStatus.setExplanation(new I18NString(bundleName, "NoDependents"));
            return statusType4;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Status status = (Status)enumeration.nextElement();
            String string = status.getName().getKey();
            if (string.equals("Port")) {
                statusType = status.getStatusType();
                continue;
            }
            if (string.equals("AdminPort")) {
                statusType2 = status.getStatusType();
                continue;
            }
            if (!string.startsWith("Mau")) continue;
            statusType3 = status.getStatusType();
        }
        if (statusType3 == null) {
            statusType3 = StatusType.NORMAL;
            bl = true;
        }
        if (statusType == null || statusType2 == null) {
            statusType4 = StatusType.UNKNOWN;
            compoundStatus.setExplanation(new I18NString(bundleName, "MissingDependent"));
            return statusType4;
        }
        if (statusType2.equals(StatusType.NORMAL) && statusType.equals(StatusType.NORMAL) && statusType3.equals(StatusType.NORMAL)) {
            statusType4 = StatusType.NORMAL;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortNormal"));
            return statusType4;
        }
        if (statusType2.equals(StatusType.ADMIN_DISABLED)) {
            statusType4 = StatusType.ADMIN_DISABLED;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortAdminDisabled"));
            return statusType4;
        }
        if (statusType3.equals(StatusType.ADMIN_DISABLED)) {
            statusType4 = StatusType.ADMIN_DISABLED;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortMauAdminDisabled"));
            return statusType4;
        }
        if (statusType.equals(StatusType.CRITICAL) || statusType3.equals(StatusType.CRITICAL)) {
            statusType4 = StatusType.CRITICAL;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortCritical"));
            return statusType4;
        }
        if (statusType.equals(StatusType.MARGINAL)) {
            statusType4 = StatusType.MARGINAL;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortMarginal"));
            return statusType4;
        }
        if (statusType.equals(StatusType.NORMAL) && statusType3.equals(StatusType.MARGINAL)) {
            statusType4 = StatusType.MARGINAL;
            compoundStatus.setExplanation(new I18NString(bundleName, "PortMarginal"));
            return statusType4;
        }
        if (bl) {
            if (statusType2.equals(StatusType.UNKNOWN) && statusType.equals(StatusType.UNKNOWN)) {
                statusType4 = StatusType.UNKNOWN;
                compoundStatus.setExplanation(new I18NString(bundleName, "PortUnknown"));
                return statusType4;
            }
            if (statusType2.equals(StatusType.UNKNOWN) || statusType.equals(StatusType.UNKNOWN)) {
                statusType4 = StatusType.UNKNOWN;
                compoundStatus.setExplanation(new I18NString(bundleName, "PortMarginalUnknown"));
                return statusType4;
            }
        } else {
            if (statusType2.equals(StatusType.UNKNOWN) && statusType.equals(StatusType.UNKNOWN) && statusType3.equals(StatusType.UNKNOWN)) {
                statusType4 = StatusType.UNKNOWN;
                compoundStatus.setExplanation(new I18NString(bundleName, "PortUnknown"));
                return statusType4;
            }
            if (statusType2.equals(StatusType.UNKNOWN) || statusType.equals(StatusType.UNKNOWN) || statusType3.equals(StatusType.UNKNOWN)) {
                statusType4 = StatusType.UNKNOWN;
                compoundStatus.setExplanation(new I18NString(bundleName, "PortMarginalUnknown"));
                return statusType4;
            }
        }
        statusType4 = StatusType.ADMIN_DISABLED;
        compoundStatus.setExplanation(new I18NString(bundleName, "PortOperDisabled"));
        return statusType4;
    }

    static {
        bundleName = "ibm.nways.lspeed.LsGeneralResources";
    }
}

